#include <iostream>
#include <string>
#include <random>
#include "CmdLineParser.h"
#include "JointVonMisesCircular.h"
#include "FileHandler.h"
#include "AminoAcidMapper.h"
#include "Sampler.h"
#include "Constants.h"


using namespace std;


int main(int argc, char *argv[]) {

    size_t nsamples;
    string modelPath;
    string type = Constants::DEG;
    string mode;
    char samplingOption;
    vector<float> backbonePair(2, 0);

    CmdLineParser::parseCmdLine(argc, argv, nsamples, mode, modelPath, type, samplingOption, backbonePair);
    size_t angleCount;
    AminoAcid aa;

    vector<JointVonMisesCircular> mixtureModel = FileHandler::readMixtureModel(modelPath, aa, angleCount);

    switch (samplingOption) {
        case Constants::CONDITIONAL: {
            random_device rd;
            angleCount = angleCount - 2;

            mt19937 gen(rd());
            vector<vector<float>> sampledData = Sampler::sampleConditionalSideChain(mixtureModel, angleCount, nsamples,
                                                                                    backbonePair, gen);
            FileHandler::outputDataFrame(sampledData, angleCount, type, nsamples, samplingOption);
            break;
        }
        case Constants::JOINT: {
            random_device rd;
            mt19937 gen(rd());
            vector<vector<float>> sampledData = Sampler::sampleJointVonMisesMixture(nsamples, mixtureModel, angleCount,
                                                                                    gen);
            FileHandler::outputDataFrame(sampledData, angleCount, type, nsamples, samplingOption);
            break;
        }
        default: {
            return 0; // will be handled at the CmdLineParser
        }
    }
    return 0;
}

