#include "AminoAcidMapper.h"
#include <iostream>
#include <unordered_map>

unsigned int AminoAcidMapper::getSideChainAngleCount(const AminoAcid &aa) {
    switch (aa) {
        case ALA:
            return 0;
        case GLY:
            return 0;
        case ILE:
            return 2;
        case LEU:
            return 2;
        case PRO:
            return 2;
        case PHE:
            return 2;
        case TRP:
            return 2;
        case TYR:
            return 2;
        case ASP:
            return 2;
        case GLU:
            return 3;
        case VAL:
            return 1;
        case ARG:
            return 5;
        case HIS:
            return 2;
        case LYS:
            return 4;
        case SER:
            return 1;
        case THR:
            return 1;
        case CYS:
            return 1;
        case MET:
            return 3;
        case ASN:
            return 2;
        case GLN:
            return 3;
        default:
            cout << "Unrecognized amino acid " << aa << " .exiting..." << endl;
            exit(1);
    }
}

AminoAcid AminoAcidMapper::getAminoAcidEnum(const string& aminoAcid) {
    unordered_map<std::string,AminoAcid> const table = {
            {"ALA",AminoAcid::ALA},
            {"GLY",AminoAcid::GLY},
            {"ILE",AminoAcid::ILE},
            {"LEU",AminoAcid::LEU},
            {"PRO",AminoAcid::PRO},
            {"PHE",AminoAcid::PHE},
            {"TRP",AminoAcid::TRP},
            {"TYR",AminoAcid::TYR},
            {"ASP",AminoAcid::ASP},
            {"GLU",AminoAcid::GLU},
            {"VAL",AminoAcid::VAL},
            {"ARG",AminoAcid::ARG},
            {"HIS",AminoAcid::HIS},
            {"LYS",AminoAcid::LYS},
            {"SER",AminoAcid::SER},
            {"THR",AminoAcid::THR},
            {"CYS",AminoAcid::CYS},
            {"MET",AminoAcid::MET},
            {"ASN",AminoAcid::ASN},
            {"GLN",AminoAcid::GLN}
    };
    auto it = table.find(aminoAcid);
    if (it != table.end()) {
        return it->second;
    } else {
        return INVALID;
    }
}

string AminoAcidMapper::getAminoAcidEnumStringify(enum AminoAcid aminoAcid) {

    string aminoAcidName[] = {
            "ALA",
            "GLY",
            "ILE",
            "LEU",
            "PRO",
            "PHE",
            "TRP",
            "TYR",
            "ASP",
            "GLU",
            "VAL",
            "ARG",
            "HIS",
            "LYS",
            "SER",
            "THR",
            "CYS",
            "MET",
            "ASN",
            "GLN",
            "TES"
    };
    return aminoAcidName[aminoAcid];
}